function inViewport($el) {
    var elH = $el.outerHeight(),
        H   = $(window).height(),
        r   = $el[0].getBoundingClientRect(), t=r.top, b=r.bottom;
    return Math.max(0, t>0? Math.min(elH, H-t) : Math.min(b, H));
}

var menu_scrollbar = function(){

    jQuery('#doc-menu').css( 'width', '' );
    jQuery('#doc-menu').css( 'height', '' );
    jQuery('#doc-menu').css( 'overflow', '' );
    
    var view_area_height    = inViewport($('#doc-menu'));
    var doc_menu_height     = jQuery('#doc-menu').innerHeight();
    var doc_menu_width     = jQuery('#doc-menu').innerWidth();

    if( view_area_height < doc_menu_height ){
        jQuery('#doc-menu').css( 'width', doc_menu_width + 'px' );
        jQuery('#doc-menu').css( 'height', view_area_height + 'px' );
        jQuery('#doc-menu').css('overflow', 'auto');
    }
};

$(window).on("scroll resize", function(){
    // menu scrollbar
    menu_scrollbar();
});


$(document).ready(function() {

    // menu scrollbar
    menu_scrollbar();
    
    /* ===== Stickyfill ===== */
    /* Ref: https://github.com/wilddeer/stickyfill */
    // Add browser support to position: sticky
    var elements = $('.sticky');
    Stickyfill.add(elements);
  
    
    /* Hack related to: https://github.com/twbs/bootstrap/issues/10236 */
    $(window).on('load resize', function() {
        $(window).trigger('scroll'); 
    });

    /* Activate scrollspy menu */
    $('body').scrollspy({target: '#doc-menu', offset: 100});
    
    /* Smooth scrolling */
	$('a.scrollto').on('click', function(e){
        //store hash
        var target = this.hash;    
        e.preventDefault();
		$('body').scrollTo(target, 800, {offset: 0, 'axis':'y'});
		
	});
	
    
    /* ======= jQuery Responsive equal heights plugin ======= */
    /* Ref: https://github.com/liabru/jquery-match-height */
    
    // $('#cards-wrapper .item-inner').matchHeight();
    // $('#showcase .card').matchHeight();
     
    /* Bootstrap lightbox */
    /* Ref: http://ashleydw.github.io/lightbox/ */

    $(document).delegate('*[data-toggle="lightbox"]', 'click', function(e) {
        e.preventDefault();
        $(this).ekkoLightbox();
    });    

    $("img").not('.main-logo, .layout-image, .footer-logo').each(function(index, element) {
        $(element).wrap('<a class="zoomthis" href="'+$(element).attr('src')+'"></a>');
    });

    $('body').lightGallery({
        selector: '.zoomthis',
        thumbnail: false,
        share: false,
        rotate: false,
        hash: false,
        downloadUrl: false,
        controls: false,
        counter: false
    });

});